/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.inbaskets;

import filenet.vw.api.VWQueueDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketPropertyPanel;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.uicontrols.border.VWLineBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class VWDesignerWorkBasketPanel
extends VWWorkBasketPanel
implements ActionListener,
IVWCoordinationEventListener {
    private VWDesignerCoreData m_designerCoreData = null;
    private JComboBox m_queuesCombo;

    public VWDesignerWorkBasketPanel(VWDesignerCoreData designerCoreData) {
        super(designerCoreData.getSessionInfo());
        this.m_designerCoreData = designerCoreData;
        this.initQueueComboBox(null);
        designerCoreData.getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_queuesCombo)) {
            VWQueueDefinition queuedef = (VWQueueDefinition)this.m_queuesCombo.getSelectedItem();
            this.notifyListeners();
            if (queuedef != null) {
                this.setQueueDefinition(queuedef);
            }
        }
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        switch (event.getID()) {
            case 757: {
                this.stopEditing();
                this.resetModifiedFlag();
                this.reselectQueue();
                break;
            }
            case 770: 
            case 771: 
            case 772: {
                this.stopEditing();
                this.reselectQueue();
            }
        }
    }

    protected void createControls() {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JPanel leftPanel = this.createWorkBasketTablePanel();
            this.m_workBasketPropertyPanel = new VWWorkBasketPropertyPanel(this.m_sessionInfo, false);
            VWSplitPane splitPane = new VWSplitPane(1, leftPanel, this.m_workBasketPropertyPanel);
            splitPane.setDividerLocation(0.25);
            splitPane.setResizeWeight(0.25);
            this.add((Component)splitPane, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createWorkBasketTablePanel() {
        try {
            JPanel workBasketTablePanel = new JPanel(new BorderLayout(6, 6));
            workBasketTablePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            workBasketTablePanel.add((Component)this.getSelectQueuePanel(), "First");
            JPanel wbPanel = super.createWorkBasketTablePanel();
            wbPanel.setBorder(new VWLineBorder());
            workBasketTablePanel.add((Component)wbPanel, "Center");
            return workBasketTablePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected void notifyListeners() {
        if (this.isModified()) {
            this.resetModifiedFlag();
            VWQueueDefinition queueDef = this.getQueueDefinition();
            if (queueDef != null) {
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 771, queueDef.getName());
            }
        }
    }

    protected void releaseResources() {
        if (this.m_queuesCombo != null) {
            this.m_queuesCombo.removeActionListener(this);
            this.m_queuesCombo.removeAll();
            this.m_queuesCombo = null;
        }
        this.m_designerCoreData = null;
        super.releaseResources();
    }

    private JPanel getSelectQueuePanel() {
        JPanel queuePanel = new JPanel(new BorderLayout(3, 3));
        queuePanel.add((Component)new JLabel(VWResource.s_queueForInbaskets), "First");
        this.m_queuesCombo = new JComboBox();
        this.m_queuesCombo.setRenderer(new VWLabelListCellRenderer());
        this.m_queuesCombo.addActionListener(this);
        queuePanel.add((Component)this.m_queuesCombo, "Last");
        return queuePanel;
    }

    private void initQueueComboBox(VWQueueDefinition selectedQueueDef) {
        block7: {
            try {
                int nTypes = 3;
                Object[] queueDefs = this.m_designerCoreData.getDataDictionary().getQueueDefinitions(nTypes);
                if (queueDefs == null) break block7;
                VWQubbleSort.sort(queueDefs);
                DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>(queueDefs);
                this.m_queuesCombo.setModel(cbModel);
                if (selectedQueueDef == null) break block7;
                for (int i = 0; i < queueDefs.length; ++i) {
                    if (VWStringUtils.compare(((VWQueueDefinition)selectedQueueDef).getName(), ((VWQueueDefinition)queueDefs[i]).getName()) != 0) continue;
                    selectedQueueDef = queueDefs[i];
                    break;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        if (this.m_queuesCombo.getModel().getSize() > 0) {
            if (selectedQueueDef != null) {
                this.m_queuesCombo.setSelectedItem(selectedQueueDef);
            } else {
                this.m_queuesCombo.setSelectedIndex(0);
            }
        } else {
            this.m_queuesCombo.setEnabled(false);
            this.setEnabled(false);
        }
    }

    private void reselectQueue() {
        VWQueueDefinition queueDef = (VWQueueDefinition)this.m_queuesCombo.getSelectedItem();
        int nRow = this.m_workBasketTable.getSelectedRow();
        this.initQueueComboBox(queueDef);
        if (nRow == this.m_workBasketTable.getSelectedRow()) {
            this.m_workBasketTable.clearSelection();
        }
        if (nRow != -1 && nRow < this.m_workBasketTable.getModel().getRowCount()) {
            this.m_workBasketTable.setRowSelectionInterval(nRow, nRow);
        }
    }
}

